	subroutine SHAPEM(iout, idbg, Ne, Ng, Sx, V, D, &
			 Ae, Le, Be, wg, e, Shp, dNdr, Wgt, Jac, Ji)
! calculate element matrices

	implicit none
	integer iout, idbg
	integer Ne, Ng			! array parameters
	real*8 Sx
	real*8 Ae(2,2), Le(2,2), Be(2,2)	! element arrays
	real*8 V(Ne,1), D(Ne,1,1)		! global  arrays
	real*8 wg(Ng)				! Gauss weights
	real*8 Ji(1,1,Ng,1), Jac(Ng,1)			! geometric entities
	real*8 Shp(2,Ng,1), dNdr(2,1,Ng,1), Wgt(2,Ng,1)	! shape and weight functions
	integer e

	integer g1, i, p, k, q, ii, jj
	real*8 w

!	write(idbg,'(a)') ' --- SHAPEM ---'	! ### TEMPORARY ###

	Ae = 0.d0	! use matrix form
	Le = 0.d0	! use matrix form
	Be = 0.d0	! use matrix form

	do g1 = 1, Ng
	    w = wg(g1)

! calculate the mass matrix, Ae
! consistent mass matrix:
	    do ii = 1, 2
	      do jj = 1, 2
	        Ae(ii,jj) = Ae(ii,jj) + Sx * w * Wgt(ii,g1,1) * Shp(jj,g1,1) * Jac(g1,1)
	      enddo	! jj
	    enddo	! ii

! calculate the advection matrix, Le (Non-Symmetric)
	    do i = 1,1
	      do k = 1,1
	        do ii = 1, 2
	          do jj = 1, 2
		    Le(ii,jj) = Le(ii,jj) - Sx * w * Wgt(ii,g1,1) * V(e,1) * &
				dNdr(jj,k,g1,1) * Ji(k,i,g1,1) * Jac(g1,1)
	          enddo	! jj
	        enddo	! ii
	      enddo	! k
	    enddo	! i

! calculate the conduction matrix, Be
	    do i = 1,1
	      do p = 1,1
	        do k = 1,1
	          do q = 1,1
	            do ii = 1, 2
	              do jj = 1, 2
!!! dN/dr should be replaced by dW/dr in the following line !!!
			Be(ii,jj) = Be(ii,jj) + Sx * w * dNdr(ii,k,g1,1) * Ji(k,i,g1,1) * &
				    D(e,i,p) * dNdr(jj,q,g1,1) * Ji(q,p,g1,1) * Jac(g1,1)
	              enddo	! jj
	            enddo	! ii
	          enddo		! q
	        enddo		! k
	      enddo		! p
	    enddo		! i

	enddo	! g1
	
	return
	end
